/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.builders;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

public interface Builder<R, T extends R, P, S extends Builder<R, T, P, S>>
extends NonNullSupplier<RegistryEntry<T>> {
    public RegistryEntry<T> register();

    public AbstractRegistrate<?> getOwner();

    public P getParent();

    public String getName();

    public class_5321<? extends class_2378<R>> getRegistryKey();

    @Override
    default public RegistryEntry<T> get() {
        return this.getOwner().get(this.getName(), this.getRegistryKey());
    }

    default public T getEntry() {
        return ((RegistryEntry)this.get()).get();
    }

    public NonNullSupplier<T> asSupplier();

    default public <D extends RegistrateProvider> S setData(ProviderType<? extends D> type, NonNullBiConsumer<DataGenContext<R, T>, D> cons) {
        this.getOwner().setDataGenerator(this, type, prov -> cons.accept(DataGenContext.from(this, this.getRegistryKey()), prov));
        return (S)this;
    }

    default public <D extends RegistrateProvider> S addMiscData(ProviderType<? extends D> type, NonNullConsumer<? extends D> cons) {
        this.getOwner().addDataGenerator(type, cons);
        return (S)this;
    }

    default public S onRegister(NonNullConsumer<? super T> callback) {
        this.getOwner().addRegisterCallback(this.getName(), this.getRegistryKey(), callback);
        return (S)this;
    }

    default public <OR> S onRegisterAfter(class_5321<? extends class_2378<OR>> dependencyType, NonNullConsumer<? super T> callback) {
        return this.onRegister(e -> {
            if (this.getOwner().isRegistered(dependencyType)) {
                callback.accept(e);
            } else {
                this.getOwner().addRegisterCallback(dependencyType, () -> callback.accept(e));
            }
        });
    }

    default public <R2, T2 extends R2, P2, S2 extends Builder<R2, T2, P2, S2>> S2 transform(NonNullFunction<S, S2> func) {
        return (S2)((Builder)func.apply(this));
    }

    default public P build() {
        this.register();
        return this.getParent();
    }
}

